# EcomFlow Blog Generator API

Next.js API route for generating AI-powered blog posts with research, writing, and image generation.

## Setup

1. Install the dependency:
```bash
npm install @google/genai
```

2. Add to your Next.js project:
```
app/
  api/
    generate-posts/
      route.ts  <-- place the file here
```

3. Set your environment variable:
```
GEMINI_API_KEY=your_api_key_here
```

## Usage

```typescript
const response = await fetch('/api/generate-posts', {
  method: 'POST',
  headers: { 'Content-Type': 'application/json' },
  body: JSON.stringify({ postCount: 2 }) // 1-10 posts
});

const { posts, costs } = await response.json();
```

## Response Format

```typescript
{
  posts: [{
    title: string,
    summary: string,
    content: string,      // Markdown
    sourceUrl: string,
    sourceTitle: string,
    imageUrl: string      // Base64 or fallback URL
  }],
  costs: {
    research: { model, inputTokens, outputTokens, searchQueries, estimatedCost },
    writing: { model, inputTokens, outputTokens, estimatedCost },
    images: { model, imageCount, estimatedCost },
    total: number
  }
}
```

## Pipeline

1. **Research** - Gemini 2.5 Flash with Google Search grounding finds relevant news
2. **Writing** - Gemini 3 Pro generates authoritative blog content
3. **Images** - Gemini 2.5 Flash Image creates header images

Estimated cost: ~$0.05-0.10 per generation (2 posts)
